<?php
defined( 'ABSPATH' ) or die();

// The third-party libraries
require_once MARLAB_PATH . 'vendor/class-tgm-plugin-activation.php';

// Classes
require_once MARLAB_PATH . 'admin/inc/class-plugins-activation.php';
require_once MARLAB_PATH . 'admin/inc/class-sample-data.php';

// Register theme's assets
add_action( 'init', 'marlab_setup_admin_assets' );


if ( ! function_exists( 'marlab_setup_admin_assets' ) ):
/**
 * Register scripts and styles for the theme
 * 
 * @return  void
 */
function marlab_setup_admin_assets() {
	// Font Icons
	wp_register_style( 'font-icons', get_theme_file_uri( 'assets/css/components.css' ), array(), '4.7.0' );
	
	// Chosen
	wp_register_style( 'marlab-chosen', get_theme_file_uri( 'admin/js/vendor/chosen/chosen.min.css' ), array(), MARLAB_VERSION );
	wp_register_script( 'marlab-chosen', get_theme_file_uri( 'admin/js/vendor/chosen/chosen.jquery.min.js' ), array( 'jquery' ), MARLAB_VERSION, true );
	
	// Spectrum
	wp_register_style( 'marlab-spectrum', get_theme_file_uri( 'admin/js/vendor/spectrum/spectrum.css' ), array(), MARLAB_VERSION );
	wp_register_script( 'marlab-spectrum', get_theme_file_uri( 'admin/js/vendor/spectrum/spectrum.js' ), array( 'jquery' ), MARLAB_VERSION, true );

	// Spectrum
	wp_register_style( 'marlab-iconpicker', get_theme_file_uri( 'admin/js/vendor/iconpicker/css/jquery.fonticonpicker.css' ), array(), MARLAB_VERSION );
	wp_register_script( 'marlab-iconpicker', get_theme_file_uri( 'admin/js/vendor/iconpicker/fonticonpicker.js' ), array( 'jquery' ), MARLAB_VERSION, true );

	// VueJS library
	wp_register_script( 'vuejs', get_theme_file_uri( 'admin/js/vendor/vue.js' ), array(), MARLAB_VERSION, true );

	/**
	 * Core scripts
	 */
	wp_register_script( 'marlab-options', get_theme_file_uri( 'admin/js/options.js' ), array(
		'vuejs',
		'marlab-spectrum',
		'marlab-chosen',
		'wp-plupload',
		'jquery-ui-resizable',
		'jquery-ui-sortable',
		'marlab-iconpicker'
	), MARLAB_VERSION, true );

	wp_register_style( 'marlab-options', get_theme_file_uri( 'admin/css/options.css' ), array(
		'font-icons',
		'marlab-chosen',
		'marlab-spectrum',
		'marlab-iconpicker'
	), MARLAB_VERSION );
	
	wp_register_style( 'marlab-customize', get_theme_file_uri( 'admin/css/customize.css' ), array( 'marlab-options' ), MARLAB_VERSION );
}
endif;

add_filter('acf/settings/save_json', function() {
	return get_theme_file_path( 'admin/json/' );
} );

add_filter('acf/settings/load_json', function( $paths ) {
    return array( get_theme_file_path( 'admin/json/' ) );
} );