<?php
defined( 'ABSPATH' ) or die();


// Add filter to register customize containers
add_filter( 'marlab_customize_containers', 'marlab_customize_footer_containers' );
add_filter( 'marlab_customize_settings', 'marlab_customize_footer_settings' );


// Add filter to register customize controls
add_filter( 'marlab_customize_controls', 'marlab_customize_footer_controls' );
add_filter( 'marlab_customize_controls', 'marlab_customize_footer_content_bottom_controls' );
add_filter( 'marlab_customize_controls', 'marlab_customize_footer_widgets_controls' );
add_filter( 'marlab_customize_controls', 'marlab_customize_footer_copyright_controls' );


function marlab_customize_footer_containers( $containers ) {
	$containers['footerGeneral'] = array(
		'type'    => 'section',
		'panel'   => 'headerAndFooter',
		'title'   => _x( 'General Settings', 'customize', 'marlab' ),
		'heading' => array(
			'title'       => _x( 'Footer Settings', 'customize', 'marlab' ),
			'description' => _x( '', 'customize', 'marlab' )
		)
	);
	$containers['footerContentBottom'] = array(
		'type'  => 'section',
		'panel' => 'headerAndFooter',
		'title' => _x( 'Content Bottom', 'customize', 'marlab' )
	);
	$containers['footerWidgets'] = array(
		'type'  => 'section',
		'panel' => 'headerAndFooter',
		'title' => _x( 'Footer Widget', 'customize', 'marlab' )
	);
	$containers['footerCopyright'] = array(
		'type'  => 'section',
		'panel' => 'headerAndFooter',
		'title' => _x( 'Copyright Settings', 'customize', 'marlab' )
	);

	return $containers;
}


function marlab_customize_footer_settings( $settings ) {
	$settings['footer__background'] = array( 'default' => array() );
	$settings['footer__typography'] = array( 'default' => array() );
	$settings['footer__colors']     = array( 'default' => array() );
	$settings['footer__padding']    = array( 'default' => array() );


	$settings['footer__copyright']             = array( 'default' => 'on' );
	$settings['footer__copyright__content']    = array( 'default' => 'Copyright &copy; 2021 LineThemes' );
	$settings['footer__copyright__full']         = array( 'default' => 'off' );
	$settings['footer__copyright__typography'] = array( 'default' => array() );
	$settings['footer__copyright__colors'] = array( 'default' => array() );
	$settings['footer__copyright__padding'] = array( 'default' => array() );
	$settings['footer__copyright__background'] = array( 'default' => array() );


	$settings['footer__widgets']                  = array( 'default' => 'on' );
	$settings['footer__widgets__layout']          = array( 'default' => array(
		'columns' => 4,
		'layout'  => array(
			1 => array( 12 ),
			2 => array( 6, 6 ),
			3 => array( 4, 4, 4 ),
			4 => array( 3, 3, 3, 3 ),
		)
	) );
	$settings['footer__widgets__full']            = array( 'default' => 'off' );
	$settings['footer__widgets__padding']         = array( 'default' => array() );
	$settings['footer__widgets__background']      = array( 'default' => array() );
	$settings['footer__widgets__typography']      = array( 'default' => array() );
	$settings['footer__widgets__colors']          = array( 'default' => array() );
	$settings['footer__widgets__title']           = array( 'default' => array() );
	$settings['footer__widgets__margin']          = array( 'default' => array() );

	return $settings;
}



function marlab_customize_footer_controls( $controls ) {
	$controls['footer__background'] = array(
		'type'        => 'background',
		'section'     => 'footerGeneral',
		'label'       => _x( 'Footer Background', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' )
	);

	$controls['footer__typography'] = array(
		'type'        => 'typography',
		'section'     => 'footerGeneral',
		'label'       => _x( 'Footer Font', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' )
	);
	$controls['footer__colors'] = array(
		'type'        => 'colors',
		'section'     => 'footerGeneral',
		'label'       => _x( 'Footer Link Colors', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' ),
		'choices'     => array(
			'link'      => _x( 'Link', 'customize', 'marlab' ),
			'linkHover' => _x( 'Link Hover', 'customize', 'marlab' )
		)
	);
	$controls['footer__padding'] = array(
		'type'        => 'dimension',
		'section'     => 'footerGeneral',
		'label'       => _x( 'Footer Padding', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' ),
		'choices'     => array(
			'padding-top'    => _x( 'Top', 'customize', 'marlab' ),
			'padding-right'  => _x( 'Right', 'customize', 'marlab' ),
			'padding-bottom' => _x( 'Bottom', 'customize', 'marlab' ),
			'padding-left'   => _x( 'Left', 'customize', 'marlab' )
		)
	);

	return $controls;
}



function marlab_customize_footer_copyright_controls( $controls ) {
	$controls['footer__copyright'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'footerCopyright',
		'label'       => _x( 'Enable Copyright Bar', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' )
	);
	$controls['footer__copyright__full'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'footerCopyright',
		'label'       => _x( '100% Full Width', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' )
	);
	$controls['footer__copyright__content'] = array(
		'type'        => 'textareafield',
		'section'     => 'footerCopyright',
		'label'       => _x( 'Copyright Content', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' )
	);
	$controls['footer__copyright__background'] = array(
		'type'        => 'background',
		'section'     => 'footerCopyright',
		'label'       => _x( 'Copyright Bar Background', 'customize', 'marlab' )
	);

	$controls['footer__copyright__typography'] = array(
		'type'        => 'typography',
		'section'     => 'footerCopyright',
		'label'       => _x( 'Typography', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' )
	);
	$controls['footer__copyright__colors'] = array(
		'type'        => 'colors',
		'section'     => 'footerCopyright',
		'label'       => _x( 'Link Colors', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' ),
		'choices'     => array(
			'link'      => _x( 'Link', 'customize', 'marlab' ),
			'linkHover' => _x( 'Link Hover', 'customize', 'marlab' )
		)
	);
	$controls['footer__copyright__padding'] = array(
		'type'        => 'dimension',
		'section'     => 'footerCopyright',
		'label'       => _x( 'Padding', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' ),
		'choices'     => array(
			'padding-top'    => _x( 'Top', 'customize', 'marlab' ),
			'padding-right'  => _x( 'Right', 'customize', 'marlab' ),
			'padding-bottom' => _x( 'Bottom', 'customize', 'marlab' ),
			'padding-left'   => _x( 'Left', 'customize', 'marlab' )
		)
	);

	return $controls;
}

function marlab_customize_footer_content_bottom_controls( $controls ) {
	$controls['contentBottom__widgets'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'footerContentBottom',
		'label'       => _x( 'Enable Content Bottom Areas', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' )
	);
	$controls['contentBottom__widgets__full'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'footerContentBottom',
		'label'       => _x( '100% Full Width', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' )
	);
	$controls['contentBottom__widgets__layout'] = array(
		'type'        => 'column-layout',
		'section'     => 'footerContentBottom',
		'label'       => _x( 'Widgetized Layout Builder', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' )
	);
	$controls['contentBottom__widgets__background'] = array(
		'type'        => 'background',
		'section'     => 'footerContentBottom',
		'label'       => _x( 'Content Bottom Background', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' )
	);
	$controls['contentBottom__widgets__padding'] = array(
		'type'        => 'dimension',
		'section'     => 'footerContentBottom',
		'label'       => _x( 'Content Bottom Padding', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' ),
		'choices'     => array(
			'padding-top'    => _x( 'Top', 'customize', 'marlab' ),
			'padding-right'  => _x( 'Right', 'customize', 'marlab' ),
			'padding-bottom' => _x( 'Bottom', 'customize', 'marlab' ),
			'padding-left'   => _x( 'Left', 'customize', 'marlab' )
		)
	);
	$controls['contentBottom__widgets__typography'] = array(
		'type'        => 'typography',
		'section'     => 'footerContentBottom',
		'label'       => _x( 'Content Bottom Font', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' )
	);
	$controls['contentBottom__widgets__colors'] = array(
		'type'        => 'colors',
		'section'     => 'footerContentBottom',
		'label'       => _x( 'Content Bottom Link Colors', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' ),
		'choices'     => array(
			'link'      => _x( 'Link', 'customize', 'marlab' ),
			'linkHover' => _x( 'Link Hover', 'customize', 'marlab' )
		)
	);
	$controls['contentBottom__widgets__titleHeading'] = array(
		'type'        => 'heading',
		'section'     => 'footerContentBottom',
		'label'       => esc_html__( 'Content Bottom Widget Title Font', 'marlab' ),
	);
	$controls['contentBottom__widgets__title'] = array(
		'type'        => 'typography',
		'section'     => 'footerContentBottom'
	);
	$controls['contentBottom__widgets__margin'] = array(
		'type'    => 'dimension',
		'section' => 'footerContentBottom',
		'label'   => esc_html__( 'Content Bottom Widget Margin', 'marlab' ),
		'choices' => array(
			'margin-top'    => esc_html__( 'Top', 'marlab' ),
			'margin-right'  => esc_html__( 'Right', 'marlab' ),
			'margin-bottom' => esc_html__( 'Bottom', 'marlab' ),
			'margin-left'   => esc_html__( 'Left', 'marlab' )
		)
	);

	return $controls;
}

function marlab_customize_footer_widgets_controls( $controls ) {
	$controls['footer__widgets'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'footerWidgets',
		'label'       => _x( 'Enable Footer Widget Areas', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' )
	);
	$controls['footer__widgets__full'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'footerWidgets',
		'label'       => _x( '100% Full Width', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' )
	);
	$controls['footer__widgets__layout'] = array(
		'type'        => 'column-layout',
		'section'     => 'footerWidgets',
		'label'       => _x( 'Widgetized Layout Builder', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' )
	);
	$controls['footer__widgets__background'] = array(
		'type'        => 'background',
		'section'     => 'footerWidgets',
		'label'       => _x( 'Footer Widget Areas Background', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' )
	);
	$controls['footer__widgets__padding'] = array(
		'type'        => 'dimension',
		'section'     => 'footerWidgets',
		'label'       => _x( 'Footer Widget Areas Padding', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' ),
		'choices'     => array(
			'padding-top'    => _x( 'Top', 'customize', 'marlab' ),
			'padding-right'  => _x( 'Right', 'customize', 'marlab' ),
			'padding-bottom' => _x( 'Bottom', 'customize', 'marlab' ),
			'padding-left'   => _x( 'Left', 'customize', 'marlab' )
		)
	);
	$controls['footer__widgets__typography'] = array(
		'type'        => 'typography',
		'section'     => 'footerWidgets',
		'label'       => _x( 'Footer Widget Areas Font', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' )
	);
	$controls['footer__widgets__colors'] = array(
		'type'        => 'colors',
		'section'     => 'footerWidgets',
		'label'       => _x( 'Footer Widget Areas Link Colors', 'customize', 'marlab' ),
		'description' => _x( '', 'customize', 'marlab' ),
		'choices'     => array(
			'link'      => _x( 'Link', 'customize', 'marlab' ),
			'linkHover' => _x( 'Link Hover', 'customize', 'marlab' )
		)
	);
	$controls['footer__widgets__titleHeading'] = array(
		'type'        => 'heading',
		'section'     => 'footerWidgets',
		'label'       => esc_html__( 'Footer Widget Title Font', 'marlab' ),
	);
	$controls['footer__widgets__title'] = array(
		'type'        => 'typography',
		'section'     => 'footerWidgets'
	);
	$controls['footer__widgets__margin'] = array(
		'type'    => 'dimension',
		'section' => 'footerWidgets',
		'label'   => esc_html__( 'Footer Widget Margin', 'marlab' ),
		'choices' => array(
			'margin-top'    => esc_html__( 'Top', 'marlab' ),
			'margin-right'  => esc_html__( 'Right', 'marlab' ),
			'margin-bottom' => esc_html__( 'Bottom', 'marlab' ),
			'margin-left'   => esc_html__( 'Left', 'marlab' )
		)
	);

	return $controls;
}

