<?php
defined( 'ABSPATH' ) or die();


add_filter( 'nprojects/shortcode_template', 'marlab_project_shortcode_template' );
add_filter( 'nprojects/shortcode_parameters', 'marlab_project_shortcode_params' );
add_filter( 'the_excerpt', 'marlab_project_auto_excerpt', 99 );

add_action( 'after_setup_theme', function () {
	if ( class_exists( 'nProjects_Admin' ) ) {
		$admin = nProjects_Admin::instance();
		$meta_box_hook = 'add_meta' . '_boxes';
		
		remove_action( 'admin_enqueue_scripts', array( $admin, 'enqueue_styles' ) );
		remove_action( 'admin_enqueue_scripts', array( $admin, 'enqueue_scripts' ) );
		remove_action( 'save_post', array( $admin, 'update_media_items' ) );
		remove_action( $meta_box_hook, array( $admin, 'add_metabox' ) );
	}
} );

function marlab_project_auto_excerpt( $excerpt ) {
	if ( marlab_current_post_type() == 'nproject' && mb_strlen( $excerpt ) > marlab_option( 'projects__autoExcerptLength' ) ) {
		$excerpt = mb_substr( $excerpt, 0, marlab_option( 'projects__autoExcerptLength' ) );
	}

	return $excerpt;
}

function marlab_projects_body_class( $classes ) {
	$classes[] = sprintf( 'projects projects-%s', marlab_option( 'projects__displayMode' ) );

	return $classes;
}

function marlab_projects_sidebar() {
	return marlab_option( 'projects__sidebar' );
}

function marlab_projects_sidebar_position() {
	return marlab_option( 'projects__sidebarPosition' );
}

function marlab_single_project_sidebar() {
	return marlab_option( 'project__sidebar' );
}

function marlab_single_project_sidebar_position() {
	return marlab_option( 'project__sidebarPosition' );
}

function marlab_project_shortcode_template() {
	return 'tmpl/project/projects.php';
}