<?php
defined( 'ABSPATH' ) or die();

$classes = array( 'footer-copyright' );

if ( marlab_option( 'footer__copyright__full' ) == 'on' ) {
	$classes[] = 'footer-copyright-full';
}
?>

<?php if ( marlab_option( 'footer__copyright' ) == 'on' ): ?>
	<div class="<?php echo esc_attr( join( ' ', $classes ) ) ?>">
		<div class="footer-copyright-inner wrap">
			<?php if ( marlab_option( 'global__misc__gotop' ) == 'on' ): ?>
				<div class="go-to-top">
					<a href="javascript:;"><span><?php echo esc_html__( 'Go to Top', 'marlab' ) ?></span></a>
				</div>
			<?php endif ?>

			<div class="copyright-bar">
				<div class="copyright-content">
					<?php echo marlab_cleanup( marlab_option( 'footer__copyright__content' ) ) ?>
				</div>

				<?php marlab_social_icons( array( 'location' => 'footer' ) ) ?>
			</div>
		</div>
	</div>
	<?php endif ?>