<?php
defined( 'ABSPATH' ) or die();

// The menu settings
$primary_menu_args = array(
	'theme_location'  => 'primary',
	'container'       => false,
	'menu_class'      => 'menu menu-primary',
	'fallback_cb'     => 'marlab_page_menu',
	'items_wrap'      => '<ul id="%1$s" class="%2$s">%3$s</ul>',
	'depth'           => 0
);

$contact_info           = marlab_option( 'header__info__text' );
$header_nav_extras      = marlab_option( 'header__extras' );
$sliding_sidebarLable   = marlab_option( 'sliding__sidebarLable' );

$header_classes         = array( 'site-header' );
$header_classes[]       = sprintf( 'header-%s', marlab_option( 'header__style' ) );

$header_style = marlab_option( 'header__style' );

$current_post = get_queried_object();

if ($current_post instanceof WP_Post) {
	/**
	 * Override layout and alignment settings for the specific entry
	 */
	$_header_style = get_field( 'headerStyles', $current_post->ID );
}

if ( isset( $_header_style ) && $_header_style != 'default' ) {
	$header_style = $_header_style;
}

$header_classes = array(
	"site-header",
	"header-{$header_style}"
);

if ( marlab_option( 'header__width' ) === 'on' ) {
	$header_classes[] = 'header-full';
}

if ( marlab_option( 'header__shadow' ) === 'on' ) {
	$header_classes[] = 'header-shadow';
}

if ( marlab_option( 'header__transparent' ) === 'on' ) {
	$header_classes[] = 'header-transparent';
}

?>

<?php if ( marlab_option( 'header__topbar' ) === 'on' ): ?>
	<?php get_template_part( 'tmpl/header-topbar' ); ?>
<?php endif ?>

<div id="site-header" class="<?php echo esc_attr( join( ' ', $header_classes ) ) ?>">
	<div class="site-header-inner wrap">
		<div class="header-brand">
			<a href="<?php echo esc_attr( site_url() ) ?>">
				<?php marlab_logo( marlab_option( 'header__logo' ) ) ?>
			</a>
		</div>
		
		<nav class="navigator" itemscope="itemscope" itemtype="http://schema.org/SiteNavigationElement">
			<?php if ( has_nav_menu( 'primary' ) ): ?>
				<?php wp_nav_menu( $primary_menu_args ) ?>
			<?php endif ?>

			<?php if ( is_active_sidebar( 'off-canvas-left' ) ): ?>
				<a href="javascript:;" data-target="off-canvas-left" class="off-canvas-toggle">
					<span><?php echo marlab_cleanup( $sliding_sidebarLable ) ?></span>
				</a>
			<?php endif; ?>
		</nav>
		
		<div class="extras">
			<?php if ( ! empty( $header_nav_extras ) ): ?>
				<ul class="navigator menu-extras">
					<?php foreach ( $header_nav_extras as $type ): ?>
						<?php get_template_part( 'tmpl/header-icon', $type ); ?>
					<?php endforeach ?>
				</ul>
			<?php endif ?>
		</div>

		<?php if ( ! empty( $contact_info ) ): ?>
			<div class="header-info-text">
				<?php echo do_shortcode( $contact_info ) ?>
			</div>
		<?php endif ?>

		<?php marlab_social_icons( array( 'location' => 'nav' ) ) ?>

		<?php get_template_part( 'tmpl/header-sliding-toggle' ) ?>			
	</div>
	<!-- /.site-header-inner -->
</div>
<!-- /.site-header -->

<?php if ( marlab_option( 'header__sticky' ) === 'on' ): ?>
	<?php get_template_part( 'tmpl/header-sticky' ); ?>
	<?php endif ?>