<?php

/**
 * Prevent direct access to this file
 */
defined( 'ABSPATH' ) or die();

$options          = array( 'itemSelector' => '.project' );
$meta_information = (array)marlab_option( 'projects__meta' );

/**
 * Ignore render related box when it's disabled
 */
if ( ! is_singular( 'nproject' ) ) {
	return;
}

// Query args
$args = array(
	'post_type'      => 'nproject',
	'posts_per_page' => marlab_option( 'project__related__count', 4 ),
	'post__not_in'   => array( get_the_ID() )
);

$related_item_type = marlab_option( 'project__related__type' );

// Filter by tags
if ( 'tag' == $related_item_type ) {
	if ( ! ( $terms = get_the_terms( get_the_ID(), nProjects::TYPE_TAG ) ) )
		return;

	$args['tax_query'] = array(
		'taxonomy' => nProjects::TYPE_TAG,
		'field'    => 'term_id',
		'terms'    => wp_list_pluck( $terms, 'term_id' )
	);
}
// Filter by categories
elseif ( 'category' == $related_item_type ) {
	if ( ! ( $terms = get_the_terms( get_the_ID(), nProjects::TYPE_CATEGORY ) ) )
		return;

	$args['tax_query'] = array(
		'taxonomy' => nProjects::TYPE_CATEGORY,
		'field'    => 'term_id',
		'terms'    => wp_list_pluck( $terms, 'term_id' )
	);
}
// Show random items
elseif ( 'random' == $related_item_type ) {
	$args['orderby'] = 'rand';
}
// Show latest items
elseif ( 'recent' == $related_item_type ) {
	$args['order'] = 'DESC';
	$args['orderby'] = 'date';
}

// Create the query instance
$query = new WP_Query( $args );
$widget_title = marlab_option( 'project__related__title' );

if ( $query->have_posts() ): ?>

	<div class="projects-related projects-style1 wrap">
		<?php if ( ! empty( $widget_title ) ): ?>
			<h3 class="projects-related-title">
				<?php echo esc_html( $widget_title ) ?>
			</h3>
		<?php endif ?>

		<div class="projects-related-wrap" data-grid="<?php echo esc_attr( json_encode( $options ) ) ?>" data-columns="<?php echo esc_attr( marlab_option( 'projects__related__gridColumns' ) ) ?>">
			<?php while ( $query->have_posts() ): $query->the_post(); ?>

				<article <?php post_class( 'project' ) ?> itemscope="itemscope" itemtype="http://schema.org/CreativeWork">
					<div class="project-inner">
						<figure class="project-thumbnail">
							<a href="<?php the_permalink() ?>">
								<?php
									$image = marlab_get_image_resized( array(
										'post_id' => get_the_ID(),
										'size'    => marlab_option( 'projects__imagesize' ),
										'crop'    => marlab_option( 'projects__imagesizeCrop' ) == true
									) );

									echo marlab_cleanup( $image['thumbnail'] );
								?>
							</a>
						</figure>

						<div class="project-info">
							<div class="project-info-inner">
								<div class="project-meta">
									<?php echo get_the_term_list( get_the_ID(), 'nproject-category' ) ?>
								</div>
								
								<h2 class="project-title" itemprop="name headline">
									<a href="<?php the_permalink() ?>"><?php the_title() ?></a>
								</h2>

								<?php if ( marlab_option( 'projects__excerpt' ) == 'on' ): ?>
									<div class="project-summary">
										<?php the_excerpt() ?>
									</div>
								<?php endif ?>
							</div>
						</div>
					</div>
				</article>

			<?php endwhile ?>
		</div>
	</div>

<?php endif ?>
